<?php

declare(strict_types=1);

namespace Erlage\Photogram\Exceptions;

use Exception;
use Erlage\Photogram\SystemLogger;
use Erlage\Photogram\Reflection\TraitReflectionClassName;

final class RequestException extends Exception
{
    use TraitReflectionClassName;

    public function __construct(string $message)
    {
        parent::__construct($message);

        SystemLogger::requestException($this);
    }
}
